//
//  MCApplicationDefines.h
//  MCApplication
//
//  Created by Alykhan Jetha on Sat Jun 28 2003.
//  Copyright (c) 2003 __MyCompanyName__. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <AppKit/NSColor.h>
#import <AppKit/NSImageCell.h>
#import <AppKit/NSImage.h>
#import <AppKit/NSMenuItem.h>
#import <AppKit/NSDocument.h>

extern NSString *MCObjectPBoardType;


extern NSString *MCControlLeftArrowNotification;
extern NSString *MCControlRightArrowNotification;
extern NSString *MCControlUpArrowNotification;
extern NSString *MCControlDownArrowNotification;
extern NSString *MCControlTabKeyNotification;
extern NSString *MCControlSpaceKeyNotification;


extern NSString	*MCDocumentWillCloseNotification;
extern NSString *MCDocumentDidCloseNotification;

extern NSString *MCDocumentDidOpenNotification;

extern NSString *MCModelEditorDidFinishEditingModelNotification;

// takes a dictionary where the object is a string representation of selector with the key MCNotificationPerformSelector
// object is the sender ... ignored for now
// {
//		MCNotificationPerformSelector = @"updateInterfaceFromModel";
//
// }
extern NSString *MCWindowControllerPerformSelectorNotification;
extern NSString *MCMainWindowBookmarkBarDidChangeNotification;
extern NSString *MCMainWindowWillBeginFetchingSourceLists;
extern NSString *MCMainWindowDidEndFetchingSourceLists;

extern NSString *MCNotificationPerformSelector;



extern NSString	*MCLockChannel;
	// If your subclass of MCModelEditor or MCModelList have a 'LOCK' channel, setEnabled: is sent if appropriate
	
extern NSString * const kDLDebugDefaultKey;

typedef enum _MCQueryProcessorCompletionCode {
    MCQueryProcessorFailed								= -1,
    MCQueryProcessorNoResults							= 0,
    MCQueryProcessorCompletedSuccessfully				= 1
    
} MCQueryProcessorCompletionCode;


typedef enum _MCQueryPostProcessorCompletionCode {
    MCQueryPostProcessorFailed								= 0,
    MCQueryPostProcessorCompletedSuccessfully				= 1
    
} MCQueryPostProcessorCompletionCode;

typedef enum _MCTVToolbarButtonType {
	MCTVToolbarIconOnlyButtonType     = 0,
	MCTVToolbarIconTextButtonType     = 1,
	MCTVToolbarTextIconButtonType     = 2,
	MCTVToolbarTextOnlyButtonType     = 3
} MCTVToolbarButtonType;

/*
 Used by TextEditor framework as well as TextMergeTemplateView
 */
enum {
    UnknownStringEncoding = 0xFFFFFFFF,
    RichTextStringEncoding = 0xFFFFFFFE,
    RichTextWithGraphicsStringEncoding = 0xFFFFFFFD,
    HTMLStringEncoding = 0xFFFFFFFC,
    SimpleTextStringEncoding = 0xFFFFFFFB,
    SmallestCustomStringEncoding = 0xFFFFFFF0
};


extern NSString *MCTabViewPreferenceDidChangeNotification;
extern NSString *MCTabItemDisplayMode;

extern NSString *MCSearchFieldMenuChangedNotification;


extern NSColor*     MCWidgetBorderColor;

extern NSImageCell  *MCBlueTableRowGradient;
extern NSImageCell  *MCGreyTableRowGradient;
extern NSImageCell  *MCGraphiteTableRowGradient;
extern NSImageCell  *MCAquaTableRowGradient42px;

extern void MCRunFeatureForthcomingPanel(void);


@interface MCApplicationDefines : NSObject {
}

@end

@interface NSObject (MenuValidation)
- (BOOL)validateMenuItem:(NSMenuItem *)aMenuItem forDocument:(NSDocument *)aDocument;
- (BOOL)validateMenuItem:(NSMenuItem *)aMenuItem forSelection:(NSArray *)aSelection originalTarget:(id)aTarget;
@end
